function Building(n, x, y, g, a, d) {
	this.name = n;
	this.x = x;
	this.y = y;
	this.game = g;
	this.active = typeof a !== 'undefined' ? a : true; // default buildings are active (have event listeners)
	this.disabled = typeof d !== 'undefined' ? d : true; // default buildings are disabled (cannot enter unless activated)
	this.bitmap = null;
	this.image = null;
};

Building.current = null;

Building.prototype.getBuildingData = function() {
	if (window.buildingdata)
		return window.buildingdata[this.name];
	return null;
}

Building.prototype.init = function(image) {
	this.bitmap = new createjs.Bitmap(image);
	this.bitmap.x = this.x;
	this.bitmap.y = this.y;
	this.image = image;
	this.bitmap.cache(0, 0, this.bitmap.image.width, this.bitmap.image.height);

	if (this.bitmap != null && this.active) {
		var building = this;

		var b = this.bitmap;
		var g = this.game;
		var name = this.name;

		var container = this.game.map.container;
		this.bitmap.cursor = "pointer";

		// ELEMENT WYŁĄCZONEGO SPRZEDAWANIA BIUR
		//var hoverTimer = null;
		var dontHide = false;

		var budTiooltip = null;

		this.bitmap.addEventListener("click", function() {
			if (budTiooltip && $('#' + budTiooltip.attr('aria-describedby')).length)
				budTiooltip.tooltip('close');
			budTiooltip = null;
			// ELEMENT WYŁĄCZONEGO SPRZEDAWANIA BIUR
			//	$('.popupX').remove();
			//	window.clearTimeout(hoverTimer);
			if (!$(".ui-dialog-content").is(':visible') && window.isLoggedIn && building.disabled == false && (window.userdata["tura_aktywna"] || window.userdata["tura"] < 0)) {
				var budDat = building.getBuildingData();
				var bid = budDat["id"];
				if (bid == null) bid = 0;
				var rodzaj = budDat["rodzajBudynku"];
				if (rodzaj == "biuro") {
					$('#gameTooltip1').css({
						top: '-500px',
						left: '-500px'
					});

					// przy kliknieciu ponownie sprawdzamy czy ktoś inny nie wynajął
					$.get(window.links.studentAjaxGetOfficesData, function(resoff) {
						if (resoff != 0 && resoff != null) {
							var res = jQuery.parseJSON(resoff);
							window.userdata["biura"] = res['biura'];
							window.biurodata = jQuery.parseJSON(window.userdata['biura']);

							var biura = $.parseJSON(window.userdata.biura);
							if (biura[bid].idFirmy == window.userdata.id_firmy) {
								//wejdź do biura gracza
								createjs.Tween.get(container).to({
									x: -(b.x - 50) * 5,
									y: -b.y * 5,
									scaleX: 5,
									scaleY: 5,
									alpha: 0
								}, 1000).call(function() {
									window.location.hash = '#biuroGracza';
								});
							} else //if (parseInt(window.userdata.ilosc_biur) <= 0)
							{
								//nie masz biura -> możesz je wynająć
								if (parseInt(window.userdata["ilosc_biur"]) <= 0) {
									$("#dialog-biuro").load(window.links.studentAjaxBiuroDialog, {
										budynekId: bid
									}, function(b) {
										activateBiuro(bid);
									});
								} else {
									/*
																		$("#dialog-info").load(window.links.studentAjaxInfoDialog, { }, function() {
									                                                                        	activateInfo(parseInt(window.userdata["tura"]), 166,undefined,"Nie możesz wynająć większej ilości biur na tym etapie gry!","Posiadasz już jedno biuro!");
									                                                                	});
									*/
								}
							}
						}
					});
				} else if (rodzaj == "kontrahent") {
					//wejdź do biura kontrahenta
					Building.current = building;
					$("#gameTooltip1").css({
						top: "-500px",
						left: "-500px"
					});
					var tween = createjs.Tween.get(container).to({
						x: -(b.x - 50) * 5,
						y: -b.y * 5,
						scaleX: 5,
						scaleY: 5,
						alpha: 0
					}, 1000).call(function() {
						window.location.hash = "#biuroZlecenia1";
						//window.location.hash="#kontrahent-"+name;
					});
				} else {
					$(".gameTooltip").each(function() {
						var tname = $(this).attr('aria-describedby');
						var child = $("#" + tname);
						if (child.length > 0) {
							$(this).tooltip('close');
							$(this).attr("title", "");
						}
						$(this).attr("canvasX", "-500");
						$(this).attr("canvasY", "-500");
						$(this).prop("canvasX", "-500");
						$(this).prop("canvasY", "-500");
						$(this).css({
							top: "-500px",
							left: "-500px"
						});
					});
					var tween = createjs.Tween.get(container).to({
						x: -(b.x - 50) * 5,
						y: -b.y * 5,
						scaleX: 5,
						scaleY: 5,
						alpha: 0
					}, 1000).call(function() {
						window.location.hash = "#" + name;
					});
				}
			} else {
				g.map.bitmap.dispatchEvent("click");
			}
		});

		this.bitmap.addEventListener("mousedown", function(evt) {
			evt.addEventListener("mousemove", function(e) {
				e.target = g.map.bitmap;
				g.map.bitmap.dispatchEvent(e);
			})
			evt.target = g.map.bitmap;
			g.map.bitmap.dispatchEvent(evt);
		});

		this.bitmap.addEventListener("mouseover", function() {
			if (!$(".ui-dialog-content").is(':visible') && window.isLoggedIn) // BUDYNKOM WYLACZONYM TEZ MAJA SIE POKAZYWAC TOOLTIPY: && building.disabled == false)
				budTiooltip = building.showTooltip("#gameTooltip1", false, building);
			var budDat = building.getBuildingData();
			if (budDat == null)
				return;
			var bid = budDat["id"];
			if (bid == null) bid = 0;
			var rodzaj = budDat["rodzajBudynku"];
			if (rodzaj != "biuro")
				return;

			// WYŁĄCZAMY SPRZEDAWANIE BIUR BO NIE DZIAŁA JAK NALEŻY
			/*
			var biura = $.parseJSON(window.userdata.biura);
			if (biura[bid].idFirmy != window.userdata.id_firmy)
				return;
			hoverTimer = window.setTimeout(function(){
				var popup = $('<div class="popupX" style="z-index:0;display:none;position:fixed;left:0;right:0;width:51px;height:51px">' +
					'<div class="barbutton2" original-title="Sprzedaj biuro" title="Sprzedaj biuro" style="font-size:36px;display:block;line-height:51px;text-align:center">$</div></div>');
				popup.tipsy();
				var p = b.localToGlobal(0,0);
				$('#canvasHolder').append(popup);
				popup.css({
					left: p.x+50 + 'px',
					top: p.y+50 + 'px',
				});
				popup.fadeIn();
				popup.hover(function(){
					dontHide = true;
				},function(){
					dontHide = false;
					popup.fadeOut(400, function(){$(this).remove();});
				});
				popup.click(function(){
					popup.fadeOut(400, function(){$(this).remove();});
					console.log('sprzedaj biuro w ' + bid);
					$("#dialog-biuro").load(window.links.studentAjaxBiuroDialog, { budynekId: bid }, function() {
						activateBiuro(bid, 'sellBiuro');
					});
				});
			}, 1000);
			*/
		});

		this.bitmap.addEventListener("mouseout", function() {
			if (budTiooltip && $('#' + budTiooltip.attr('aria-describedby')).length)
				budTiooltip.tooltip('close');
			budTiooltip = null;
			// WYŁĄCZAMY SPRZEDAWANIE BIUR BO NIE DZIAŁA JAK NALEŻY
			/*
			window.clearTimeout(hoverTimer);
			if (!dontHide)
				$('.popupX').fadeOut(400, function(){
						$(this).remove();
					});
			*/
			if (!$(".ui-dialog-content").is(':visible') && window.isLoggedIn) {
				$(".gameTooltip").css( //, .ui-tooltip
					{
						top: "-500px",
						left: "-500px"
					});
			}
		});
	}
};

Building.prototype.showTooltip = function(whichTooltip, stick, object) {
	var this2 = typeof object !== 'undefined' ? object : this;
	var bitmap = this2.bitmap;
	var name = this2.name;

	var tooltipObj = $('<div class="gameTooltip sticker interiorTooltip" title="" style="top:-500px;left:-500px"></div>');
	tooltipObj.appendTo($('#canvasHolder'));

	var container = this.game.map.container;

	var width = this2.image.width;
	var height = this2.image.height;

	var x = bitmap.x;
	var y = bitmap.y;

	tooltipObj.tooltip({
		disabled: true,
		position: {
			using: function() {
				var nx = x - ($(this).outerWidth(true) - width) / 2;
				var ny = y - $(this).outerHeight(true);
				var dy = ny + container.y - 16 >= 0;
				$(this).attr("canvasY", dy ? ny - 16 : y + height + 16);
				$(this).attr("canvasX", nx);
				$(this).addClass("sticker");
				$('<div>').addClass('tooltip-arrow').addClass(dy ? 'middle' : 'top')
					.addClass('center').appendTo(this);
			}
		},
		show: {
			effect: 'slideDown',
			duration: 100
		},
		hide: {
			effect: 'slideUp',
			duration: 100
		},
		close: function(event) {
			$(event.target).remove();
		}
	});

	var logo = null;

	if (typeof window.buildingdata !== 'undefined') {
		var bid = window.buildingdata[name]["id"];
		if (bid == null) bid = 0;
		var opis = window.buildingdata[name]["opis"];
		if (opis == null) opis = "";
		var adres = window.buildingdata[name]["adres"];
		if (adres == null) adres = "";
		var ilogo = window.buildingdata[name]["urlLogo"];
		if (ilogo == null) ilogo = "";
		var rodzaj = window.buildingdata[name]["rodzajBudynku"];

		if (rodzaj == "bank") {
			var bankOpis = window.bankdata[name]["opis"];
			var bankZalozenie = window.bankdata[name]["oplataZalozenie"];
			var bankMiesieczna = window.bankdata[name]["oplataMiesieczna"];
			var bankPrzelew = window.bankdata[name]["oplataPrzelew"];
			var bankOprocentowanie = window.bankdata[name]["oprocentowanie"];
			tooltipObj.tooltip("option", "content", "<img src='" + window.links.baseUrl + "/images/" + ilogo + "' style='height: 100px;'/><br/>" + bankOpis + "<br/><span style='text-decoration:underline'>cennik usług:</span><br/>założenie konta: " + bankZalozenie + " zł<br/>" + "prowadzenie konta: " + bankMiesieczna + " zł/m<br/>opłata za przelew: " + bankPrzelew + " zł<br/>oprocentowanie: " + bankOprocentowanie + "%<br/>" + adres);
			logo = ilogo;
		} else if (rodzaj == "biuro") {
			var biuroPowierzchnia = window.biurodata[bid]["powierzchnia"];
			if (biuroPowierzchnia == null) biuroPowierzchnia = "";
			var biuroMaxPracownikow = window.biurodata[bid]["maxPracownikow"];
			if (biuroMaxPracownikow == null) biuroMaxPracownikow = "";
			var biuroCenaWynajem = window.biurodata[bid]["cenaWynajem"];
			if (biuroCenaWynajem == null) biuroCenaWynajem = "";
			var biuroCenaMedia = window.biurodata[bid]["cenaMedia"];
			if (biuroCenaMedia == null) biuroCenaMedia = "";
			var biuroIdFirmy = window.biurodata[bid]["idFirmy"];
			if (biuroIdFirmy == null) biuroIdFirmy = "";
			var biuroNazwaFirmy = window.biurodata[bid]["nazwaFirmy"];
			if (biuroNazwaFirmy == null) biuroNazwaFirmy = "";
			var biuroLogoFirmy = window.biurodata[bid]["urlLogo"];
			if (biuroLogoFirmy == null) biuroLogoFirmy = "";
			if (!biuroIdFirmy) {
				tooltipObj.tooltip("option", "content", "<span style='text-decoration:underline'>Biuro do wynajęcia:</span><br/>" + adres + "<br/><br/>" + "powierzchnia: " + biuroPowierzchnia + " m<sup>2</sup><br/>maksimum pracowników: " + biuroMaxPracownikow + "<br/>cena wynajmu: " + biuroCenaWynajem + " zł<br/>opłaty za media: " + biuroCenaMedia + " zł"
					//+"<br/>"+this.name //+opis+
				);
			} else {
				if (!biuroLogoFirmy) {
					if (biuroNazwaFirmy.length <= 1) biuroNazwaFirmy = "nieznana firma"
					tooltipObj.tooltip("option", "content", "Biuro " + adres + "<br/>wynajęte przez: " + biuroNazwaFirmy); //+" "+this.name); // +opis+
				} else {
					tooltipObj.tooltip("option", "content", "Biuro " + adres + "<br/>wynajęte przez: " + biuroNazwaFirmy + "<br/><img src='" + window.links.baseUrl + "/" + biuroLogoFirmy + "' style='height:100px;max-width:250px'/>"); //+this.name);
					logo = biuroLogoFirmy;
				}
			}
		} else if (rodzaj == "kontrahent") {
			if (bid) {
				var kontrahentNazwa = window.kontrahentdata[bid]["nazwa"];
				if (kontrahentNazwa == null) kontrahentNazwa = "";
				var kontrahentUrlLoga = window.kontrahentdata[bid]["urlLoga"];
				if (kontrahentUrlLoga == null) kontrahentUrlLoga = "";
				var kontrahentAdres = window.kontrahentdata[bid]["adres"];
				if (kontrahentAdres == null) kontrahentAdres = "";
				var kontrahentTyp = window.kontrahentdata[bid]["typ"];
				if (kontrahentTyp == null) kontrahentTyp = "";
				var kontrahentDziedzina = window.kontrahentdata[bid]["dziedzina"];
				if (kontrahentDziedzina == null) kontrahentDziedzina = "";
				if (kontrahentNazwa.length > 1 && kontrahentTyp == 1) {
					if (!kontrahentUrlLoga) {
						tooltipObj.tooltip("option", "content", "<strong>" + kontrahentNazwa + "</strong><img style='margin-left:5px;margin-top:5px' align='right' alt='" + kontrahentDziedzina +
							"' title='" + kontrahentDziedzina + "' src='" + window.links.baseUrl + '/images/gui/' + kontrahentDziedzina.toLowerCase() +
							".png' /><br/>" + adres + "<br/>"); //+this.name);
					} else {
						tooltipObj.tooltip("option", "content", "<img src='" + kontrahentUrlLoga + "' style='max-height:150px;max-width:250px;'/>" +
							"<br/><div><strong>" + kontrahentNazwa + "</strong><img style='margin-left:5px;margin-top:5px' align='right' alt='" + kontrahentDziedzina +
							"' title='" + kontrahentDziedzina + "' src='" + window.links.baseUrl + '/images/gui/' + kontrahentDziedzina.toLowerCase() +
							".png' /><br/>" + adres + "</div>"); //+this.name);
					}
				} else tooltipObj.tooltip("option", "content", "Kontrahent");
			}
		} else {
			if (!ilogo) {
				tooltipObj.tooltip("option", "content", opis + "<br/>" + adres + "<br/>"); //+this.name);
			} else {
				tooltipObj.tooltip("option", "content", "<img src='" + window.links.baseUrl + "/images/" + ilogo + "' style='height:100px;max-width: 250px;'/><br/>" + opis + "<br/>" + adres + "</br>"); //+this.name);// height 100px
			}
		}
	} else tooltipObj.tooltip("option", "content", "Pusty budynek " + name);

	tooltipObj.click(function() {
		bitmap.dispatchEvent("click");
	});

	tooltipObj.tooltip("open");

	var tname = tooltipObj.attr('aria-describedby');
	var child = $("#" + tname);
	if (child.length)
		child.css({
			left: '-500px',
			top: '-500px'
		});

	adjustDialoguePosition();

	return tooltipObj;
}

Building.prototype.highlight = function(whichTooltip, colorFilter) {
	if (colorFilter != undefined) {
		this.bitmap.filters = [new createjs.ColorFilter(1, 1, 1, 1, 0, 0, 100, 0)];
		this.bitmap.updateCache();
		//this.bitmap.cache(0,0,this.bitmap.image.width, this.bitmap.image.height);
		//this.bitmap.filters[0].applyFilter();
		//this.image = this.bitmap.image;
	} else
		this.showTooltip(whichTooltip, true);
}


Building.prototype.clearFilters = function() {
	this.bitmap.filters = [];
	this.bitmap.updateCache();
}


Building.prototype.setDisabled = function(d) {
	this.disabled = d;
}
